TITLE   'Metal Bar in a Tube, Energy Minimum'		{ exa117.pde }
SELECT     							{ Student Version }
   errlim=3e-5     ngrid=1     spectral_colors
VARIABLES   U
DEFINITIONS
   r0=1.0     b=0.3     Ub=1.0     eps0=8.854e-12
   E=-grad(U)     Em=magnitude(E)
   dU=3*( x^2+y^2- r0^2)*(x-b)*(x+b)*(y-b)*(y+b) 	{ Perturbation }
   W0=area_integral( 0.5* eps0*Em^2)		{ Energy for solution }
   U1=U-dU     E1=-grad( U1)     E1m=magnitude( E1)	
   W1=area_integral( 0.5* eps0*E1m^2)  	{ Over the entire domain }
   U2=U+dU   E2=-grad( U2)     E2m=magnitude( E2)	
   W2=area_integral( 0.5* eps0*E2m^2)
EQUATIONS
   div( grad(U))=0
BOUNDARIES
region 'domain'	
   start 'tube' (r0,0) value(U)=0  arc( center=0,0) angle=360  	
   start 'bar' (-b,-b) value( U)=Ub  line to (b,-b) to (b,b) to (-b,b)  close
PLOTS
   contour( U)     contour( dU) report( W0) report( W1) report( W2)
END


